<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage models
* @filesource
*/

/** */
require_once 'api_entity.php';

#TODO - COUNT WON'T CURRENTLY WORK (THERE'S NO COUNT RESOURCE, SO WE'LL NEED TO JUST

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/
class Folder extends API_entity {
	static $find_resource = 'direct/folders';
	static $find_one_resource = 'direct/folders';
	static $delete_resource = '/direct/folders/archive';
	
	public function is_custom_folder(){
		return is_numeric($this->id);
	}	
	
	public function name_for_display(){
		if($this->is_custom_folder()){
			return strip_from_beginning(CUSTOM_MAILBOX_PREFIX, $this->name);
		}
		return $this->name;
	}

#TODO - To follow this model's paradigm properly, this should happen when the value of parent_id is changed for a folder instance and then saved.
#This needs to be refactored - this is a temporary stopgap so that we're at least not just calling on the API in a controller
	public function change_parent($parent_id){
		if(!is_null($parent_id) && !Folder::formatted_like_an_id($parent_id)) return $this->error->should_be_null_or_a_folder_id($parent_id);
		if(!$this->is_custom_folder()) return $this->error->should_be_a_custom_folder($this);
		
		if($parent_id == $this->parent_id) return true; //if the id is already set to this value, we're done
		
		//because the API still needs to get a parent id, even if it's empty, 
		//and passing null just doesn't pass the API a parent id parameter
		//we set the parent id to an empty string here if it is null
		if(is_null($parent_id)) $parent_id = '';

		$CI = get_instance();
		$mailbox = $CI->mailbox->name;
		$folder_id = $this->id;
		

		Folder::api()->clear();
		if(!Folder::api()->call('/direct/folders/change_parent', compact('folder_id', 'parent_id', 'mailbox'), 'POST')){
			if(Folder::api()->http_status == 403){
    			$CI->session->set_flashdata('service_failure_due_to_permission_message','Failed to create folder because Manage Direct Service is disabled.');
    			$CI->session->set_flashdata('service_failure_due_to_permission',true);
    			$CI->session->set_flashdata('failed_service_name','Manage');
    		}
			return false;
		}
		
		$this->load_field_values_from_db();  
		
	   	$_SESSION['mailbox_list'] = $CI->mailformat->mailbox_list();
		return true;		
	}

#TODO - To follow this model's paradigm properly, this should happen when the value of name is changed for a folder instance and then saved.
#This needs to be refactored - this is a temporary stopgap so that we're at least not just calling on the API in a controller	
	public function rename($name){
		if(!$this->is->nonempty_string($name)) return $this->error->should_be_a_nonempty_string($name);
		if(!$this->is_custom_folder()) return $this->error->should_be_a_custom_folder($this);
		
		if($this->name_for_display() == $name) return true; //we're done
		
		$CI = get_instance();
		$values_for_api = array('mailbox' => $CI->mailbox->name,
								'folder' => $this->id,
								'name' => CUSTOM_MAILBOX_PREFIX.$name);					
		
		Folder::api()->clear();
		if(!Folder::api()->call('/direct/folders/rename', $values_for_api, 'POST')){
			return false;
		}
		
		$this->load_field_values_from_db();  
		
	   	$_SESSION['mailbox_list'] = $CI->mailformat->mailbox_list();
		return true;		
	}


/////////////////////////
// STATIC
/////////////////////////	
	
	//overrides parent because we don't have a count resource for folders	
    public static function count($id_or_conditions = array()){
		return count(static::find($id_or_conditions));
    }
	
	public static function fields(){
		return array('id', 'name', 'parent_id');  
    }	
	
	public static function find($id_or_conditions = array(), $key_by = null){
		$results = parent::find($id_or_conditions, $key_by);
		
		//since we don't actually have find_one behavior for folders, emulate this by checking to see if we have the primary key in the conditions
		$primary_key = static::$primary_key;   
		$conditions = static::_conditions_for_find($id_or_conditions);	
		if(!array_key_exists($primary_key, $conditions)) return $results;
		
		foreach($results as $key => $folder){
			if($folder->id == $conditions[$primary_key])
				return array($key => $folder);	
		}
		
		return array(); //if none of the results matched the id, we have no results
    }	
	
//not very efficient, but since we don't currently have a way of looking up just one folder or searching for a folder in the API
	public static function find_by_name($name, $key_by=null){
		foreach(static::find(array(), $key_by) as $folder){
			if($folder->name == $name) return $folder;
		}
	}
	
	
	protected static function _results_from_api_output(){
		$output = parent::_results_from_api_output();
		
		if(!is_array($output) || !array_key_exists('folder', $output))
			return array();
			
		return $output['folder'];
	}	
	
	protected static function _conditions_for_find($id_or_conditions){
		$conditions = parent::_conditions_for_find($id_or_conditions);
		$CI = get_instance();
		
		//make sure we have a mailbox - assume that it's the current mailbox if not otherwise specified
		if(!array_key_exists('mailbox', $conditions) && isset($CI->mailbox)){
			$conditions['mailbox'] = $CI->mailbox->name;
		}
		return $conditions;	
	}			
		
	protected static function _delete($entity){ 
		$class = get_called_class();
		$class::api()->clear();
		
		$values = array('folder' => $entity->id);
		
		$CI = get_instance();
		if(isset($CI->mailbox))
			$values['mailbox'] = $CI->mailbox->name;
	
		
		return $class::api()->call($class::$delete_resource, $values, 'POST');
	}
	
	protected static function _run_after_delete($entity){
        $_SESSION['mailbox_list'] = get_instance()->mailformat->mailbox_list();
	}				
		
}
